## Opening a web rails console

To get an overview of the different environments, see [Environments](web/environments.md).

#### In development

```bash
~/src/web > bundle exec rails c

Bootstrapped settings with deploy_flavor=development and rails_env=development
Loading development environment (Rails 3.2.20)
[1] pry(main)> 
```

#### In development, but hitting production data

```bash
~/src/web > RAILS_ENV=staging_direct bundle exec rails c

Bootstrapped settings with deploy_flavor=staging_direct and rails_env=staging_direct
Loading staging_direct environment (Rails 3.2.20)
>>
```

To hit production, use `RAILS_ENV=production_direct`. This is not recommended unless
you're running migrations.

#### In production

I use a script call `start-console.sh` and `admin-console.sh`, both in my home directory.

```bash
# start-console.sh
#!/bin/bash
# This starts up a rails production console. It must be run as the jtv user:
#
#   sudo -i -u jtv ./console.sh
#
echo "Starting console..."
export PATH=/home/jtv/.rbenv/bin:/home/jtv/.rbenv/shims:$PATH
cd /opt/twitch/web/current
RAILS_ENV=production bundle exec rails c
```

```bash
# admin-console.sh
#!/bin/bash
# This starts up a rails production console as the jtv user:

sudo -i -u jtv $(pwd)/start-console.sh
```
```bash
~ > ./admin-console.sh

[sudo] password for mukund:
Starting console...
Bootstrapped settings with deploy_flavor=production and rails_env=production
Loading production environment (Rails 3.2.20)
irb(main):001:0>
```
