# web/web Development Environment Setup
### Up to date for OS X 10.10.3

> This process changes often. If you see anything wrong, fix it! If you have troubles that you can't solve, ping #web in Slack!

> *`tmux` Warning*
> The setup should not be run from a terminal multiplexer like `tmux` or `screen`. Running the setup with tmux is known to cause bundler to install with incorrect permissions which causes bundle install to fail.

## Notes before you start

##### New Engineers

Be sure you have completed the steps in the [New Engineer Guide](/spinup/new.md#development-environment) before continuing.

##### Wireless Access

SSIDs and passwords live on [Confluence](https://twitchtv.atlassian.net/wiki/display/HD/IT+Support).

##### Linux Users

Scroll all the way to the bottom after finishing the Auth section. You have different install steps.

## Authorization and Authentication

##### SSH Config

##### LDAP

Reset your [Clean LDAP password](https://dashboard.internal.justin.tv/pwreset) or [Dirty LDAP password](https://dashboard.internal.justin.tv/pwreset/dirty).

Your username and email should have been provided for you, else:

Username: _firstname.lastname_ or _firstinitiallastname_ (john.doe or jdoe)

Email: add @justin.tv or @twitch.tv to your username.

If your username (`whoami`) on your local machine is different from your LDAP username,  modify your SSH config `~/.ssh/config` with two lines:

```shell
host *
user my.ldap.username
```

## Tools

##### Xcode

Install [Xcode command line tools](https://developer.apple.com/downloads/index.action).

##### Homebrew

Follow instructions at http://brew.sh/, copied below.

```shell
ruby -e "$(curl -fsSL https://raw.githubusercontent.com/Homebrew/install/master/install)"
brew doctor
brew update && brew upgrade
```

Edit your path to prefer `/usr/local/bin` if it doesn't already by adding:

```shell
export PATH="/usr/local/bin":$PATH
```

to your `~/.bash_profile`. Alternatively: `echo 'export PATH="/usr/local/bin":$PATH' >> ~/.bash_profile`

##### Git

At the time of writing, the version of Git that came with OSX had a major [security vulnerability](https://github.com/blog/1938-vulnerability-announced-update-your-git-clients).

```shell
brew install git
```

##### Edit Hosts File

Add the following to `/etc/hosts` (use sudo):

```
127.0.0.1   localhost.justin.tv
127.0.0.1   localhost.twitch.tv
```

> ##### Why am I doing this?
> When developing services that serve web pages (e.g. Rails), you should use `localhost.twitch.tv` to access that service in a browser, not `localhost`. This is because of the [same-origin policy][1]; a page under domain `A` is disallowed from making a successful request to any other domain `B`. Because our site isn't one service but several agregate services working together, your local page needs to be able to make AJAX requests to other Twitch services like `usher.twitch.tv` and `tmi.chat-internal.twitch.tv`.
>
> Developing using `localhost` means that your page won't share an origin with these services, causing those requests to be blocked and leaving your local site to lack several functionalities like video and chat.

[1]: http://en.wikipedia.org/wiki/Same-origin_policy

##### Set your shell
- open terminal and change shell `chsh -s /bin/bash <username>`.

##### Memcached

*REMINDER:* You can't run launchctl from tmux. You'll need to complete this step from a regular terminal window.

```shell
brew install memcached
mkdir -p ~/Library/LaunchAgents
ln -sfv /usr/local/opt/memcached/*.plist ~/Library/LaunchAgents/
launchctl load ~/Library/LaunchAgents/homebrew.mxcl.memcached.plist
```

##### Postgres

```shell
brew install homebrew/versions/postgresql93
```

You have to create a `~/.pgpass` file containing:

```
*:*:*:rails:thatdatabasepassword
devdb2.justin.tv:5432:*:rails:thatdatabasepassword
db8.justin.tv:5432:*:rails:thatdatabasepassword
localhost:5432:*:ttv_local_user:thatdatabasepassword
devdb2.sfo01.justin.tv:5432:*:rails:thatdatabasepassword
```

Modify the file permissions with `chmod 0600 ~/.pgpass` to ensure that only the owner can read and write to it.

Replace `thatdatabasepassword` with our db password. Ask someone for it (or check [/web/web]). If you do not create a `.pgpass` file, some tasks such as `db:structure:dump` will fail, and you might get errors when running migrations.

##### Rbenv and ruby-build

```shell
brew install rbenv ruby-build
```

Add rbenv eval to your `~/.bash_profile`

```shell
echo 'eval "$(rbenv init -)"' >> ~/.bash_profile
```

Source your profile

```shell
source ~/.bash_profile
```

## Get Code, Ruby and Bundle Dependencies

##### Clone web/web

```shell
git clone git@git.xarth.tv:web/web.git
cd web
```

##### Install Ruby
We are currently on 2.3.0.

*NOTE:* You shouldn't run any of these commands with `sudo`. If you do, the following steps will break. Make sure to run these commands from within your web directory.

```shell
rbenv install `cat .rbenv-version`
rbenv rehash
gem update --system
gem install bundler -v 1.11.2
rbenv rehash
```

It's a good idea to set your global rbenv version.  When working in a directory without a .rbenv-version file, this will ensure that ruby continues to work.

```shell
rbenv global 2.3.0
rbenv rehash
```

##### Bundle Install
*NOTE:* `bundle install` should not be run with `sudo`. If something requires elevated permissions, it's misconfigured.

```shell
bundle install
```

If you have issues with `nokogiri` failing to install, try:

```shell
brew install libxml2 libxslt
bundle install
```

If you have issues with `snappy` failing to install, try:

```shell
xcode-select --install
brew install autoconf automake libtool
bundle install
```

If you have issues with `pg` failing to install, try:

```shell
ARCHFLAGS="-arch x86_64" bundle install
```

Else, you may need to have `postgresql` present:
```shell
brew install postgresql
```

If you have issues with `eventmachine` failing to install and are on el capitan, try:

```shell
bundle config build.eventmachine --with-cppflags=-I$(brew --prefix openssl)/include
```


**After you're done with this, follow the next guide**

- [Get your tests running](https://git.xarth.tv/twitch/docs/blob/master/web/tests.md)

#### web/web-client

See instructions in the [actual repository](https://git.xarth.tv/web/web-client).

## Running a development server

Be sure to be connected to `JTV-SFO` before continuing

```shell
cd ~/twitch/web
bundle exec rails s
```

Once you see: `Listening on 0.0.0.0:3000, CTRL+C to stop`, go to [localhost](http://localhost.twitch.tv:3000) in your browser.

NOTE: You don't have to worry about raking the database on your local machine as the development and test environments are set up to use a shared database.

If rails is not installed at the end of the setup, run the following commands to install rails:

```shell
cd ~/twitch/web
gem install rails -v 3.2.18 # or whatever version is mentioned in the Gemfile of the ~/twitch/web folder
eval "$(rbenv init -)"
```

##### Chat

*Easy Method:*

```shell
cd ~/twitch/web
./config/dev/setup_chat.sh
```

If the command fails with an error message like `uglifyjs command not found`, run `npm install -g uglify-js` before retrying.

*Hard Method:*

```shell
git clone https://git.xarth.tv/chat/tmi-js-client ~/twitch/tmi
cd ~/twitch/tmi/client
make
mkdir ~/twitch/web/public/tmilibs
cd ~/twitch/web/public/tmilibs
ln -s ~/twitch/tmi/assets/JSSocket.swf
ln -s ~/twitch/tmi/deploy/dist/build/tmp/tmi.js tmi-v3.js
```

##### Run Tests

```shell
bundle exec guard start
```

Guard monitors changes to your files, and when a testable file is changed will run the test suite against the file.

You're still able to run tests normally with `bundle exec rspec`.

## Linux Users
Works for Ubuntu 15.04. Here are some misdirections to get you started:

`sudo apt-get update`

`sudo apt-get install postgresql`

`sudo apt-get install build-essential gcc curl git`

`sudo apt-get install php5`

`sudo apt-get install -y mysql-server nginx php5-cli php5-fpm php-apc git php5-mysql phpmyadmin php5-curl subversion`

`sudo apt-get install nodejs-legacy`

`sudo apt-get install ruby ruby-build libtool memcached libmemcached-dev postgresql postgresql-server-dev-all imagemagick libxslt-dev libxml2-dev libxml2 libmagickwand-dev nodejs nodejs-dev libqt4-dev`

`sudo apt-get install libcurl3 libcurl3-gnutls libcurl4-openssl-dev`

`sudo apt-get install GraphViz`

`mkdir -p ~/code/src/code.justin.tv/web/ && cd ~/code/src/code.justin.tv/web/`

`git clone git@git.xarth.tv:web/web.git`

`gpg --keyserver hkp://keys.gnupg.net --recv-keys 409B6B1796C275462A1703113804BB82D39DC0E3`

`\curl -sSL https://get.rvm.io | bash`

`source ~/.rvm/scripts/rvm`

`rvm install ruby-2.1.5`

`sudo npm install -g jshint`

`sudo npm install -g uglify-js`

`sudo apt-get install bundler`

`gem install bundler -v '~> 1.9.9'` You can do whichever version you need based on gemfile. If you need to remove a version due to a conflict

`curl https://raw.githubusercontent.com/fesplugas/rbenv-installer/master/bin/rbenv-installer | bash`

add to ~/.bashrc or ~/.bash_profile

```
export RBENV_ROOT="${HOME}/.rbenv"
if [ -d "${RBENV_ROOT}" ]; then
  export PATH="${RBENV_ROOT}/bin:${PATH}"
  eval "$(rbenv init -)"
fi

```
add to /etc/hosts :
```
127.0.0.1   localhost.justin.tv
127.0.0.1   localhost.twitch.tv
```


`sudo apt-get install flex`

`gem install rails -v 3.2.22 (make sure to specify correct version from gemfile)`

`eval "$(rbenv init -)"`

`bundle install`

`bundle exec rails s`

Should be up and running! I had some gotchas around bundler versions, so you may need to remove newer copies if they do not match the ones in the gemfile.
