# Development and Deployment Process for `web`

We start locally and end with code in `master` and on production. Acceptance testing, code review, and QA can overlap heavily.

A typical workflow:

1. Create a feature branch locally
1. Do your coding magic and write sufficient tests
1. Commit and push changes to `origin` on a remote branch
1. Ensure tests pass successfully for your branch via the [Deploy Tool](http://clean-deploy.internal.justin.tv/#/web/web)
1. Perform [Acceptance Testing](#acceptance-testing) on staging
1. If everything looks good, open a pull request to [Code Review](#code-review) your work
1. After having your branch accepted through Code Review, merge latest master into your branch, and deploy your branch to [Canary](#canary)
1. Check that Canary is sane:
    1. Watch [Canary's Grafana](https://grafana.internal.justin.tv/dashboard/db/rails-canary) for CPU (utilization) spikes compared to non-Canary
    1. Watch [Rollbar](https://rollbar.com/Twitch/Website/) for any new or unusual errors since your Canary deploy
1. Assuming no ongoing production issues, merge your Pull Request into `master`
1. Delete your remote branch
1. Ensure tests pass on `master` by looking at the [Deploy Tool](http://clean-deploy.internal.justin.tv/#/web/web)
1. **[Deploy `master` to production](#deploy-to-production)**
1. Follow [Post-Production steps](#post-production)

## Coding

Create your branch and implement your change.

```bash
git checkout master
git pull
git checkout -b my_branch_name
```

Lint it. Push it to origin.

```bash
bundle exec rubocop
git push origin -u my_branch_name
```

## Acceptance Testing

Get your branch on a staging environment and test it. Test it yourself. Have your product manager accept it.

Deploy tool lives here: https://clean-deploy.internal.justin.tv/#/web/web

Claim a staging environment on this [spreadsheet](https://docs.google.com/a/justin.tv/spreadsheets/d/1Unh6ySneYOb3nD8sM3Fy7yXv2hhzd-G197OG73ukfig/). Deploy your branch to your claimed staging environment.

![Deploy to staging](images/deploy_to_staging.png)

#### Troubleshooting Staging

If you experience broken behavior on your selected staging environment, try the following steps:

1. Deploy master of web/web-client
1. Deploy master of web/web
1. Run puppet against the nginx node of your selected staging-ffa environment 
```bash
ssh staging-ffa-8-d5a4f90f-web.dev.us-west2.justin.tv
sudo puppet agent --test
```

#### Automated Tests

While deploying a branch, you’ll see a check box that says “Trigger Smoca after deploy”. [Smoca](https://git.xarth.tv/qa/smoca) is a Black-box GUI automated test suite developed and maintained by QA.

Running Smoca will give you a wide range of testing coverage across Twitch. This helps ensure regression bugs are not introduced. When finished running (currently takes about 20 minutes), you'll receive a Slack message with the results.

**Note:** If you have multiple branches across other repos being deployed, only toggle Smoca while deploying the last branch. Otherwise, you'll trigger multiple builds while the environment isn't fully ready.

## Code Review

Once it's working, feature complete, linted, and tested, [open a pull request in Git](https://git.xarth.tv/web/web/compare).

Your pull request description should contain a brief summary of the change, how you plan to test and any risk involved.

Pull requests must be reviewed by [a set of approvers](https://git.xarth.tv/web/web/blob/eaf94e9be71c043a08ba8099fc2df30e1d6e2fb5/MAINTAINERS) with a "LGTM" or equivalent before your change can be merged into master.

Code review guidelines can be found [here](code_review_guidelines.md).

## QA (User-facing Changes)

Not all code changes require a formal QA sign-off, but for large, complex or risky changes, you should strongly consider having QA sign-off before going live in production.

Agree upon a QA environment (e.g. "clean-qa-3") with your friendly neighborhood QA analyst and deploy your branch there.

![Deploy to QA](images/deploy_to_qa.png)

Then they can test it here: http://qa-3-www.dev.us-west2.twitch.tv/

## Canary

Read how to test your changes on the web/web Canary boxes [here](canary.md).

## When You Can Deploy

You can deploy:

* During regular business hours, up until Friday at noon.
* Avoid deploying on Fridays after noon or during the weekend, unless there is an emergency.
* If there is the need for an emergency deploy outside of those times, get approval from your manager and communicate well with oncall from your team and the systems that depend on you. Ensure that others are available to help in case the deploy goes poorly.

## Before Deploying to Production

Make sure your email is public in GitHub so that the automated change notification system can route it properly. To set this up, see https://groups.google.com/a/justin.tv/forum/#!topic/tech/JdAu5M-letk

After your code works, passes QA, and is reviewed favorably by your peers, merge your changes into master.

## Deploy to Production

Deploy the new `master`, **not your branch**, to "clean-production".

![Deploy to production](images/deploy_to_production.png)

## Post-Production

When you deploy to production via the deploy tool, you will be asked some questions. You'll want to provide a description of the change, a short estimation of risks, and a link to the code review. The deploy tool will email change@twitch.tv on your behalf.

Verify your feature works as expected in production. Stick around in case it really doesn't. If it really doesn't, check out `web-client`'s procedure for [reverting a deploy](/javascript/web-client/reverting-a-deploy.md).
