Git Docs
---
If you've never used git before, take a look at the [Git docs](http://git-scm.com/documentation). Be warned: the learning curve is a bit steep, but worth it.

Common Git commands
---

* `git pull origin master`: Update your branch with the latest master code
* `git show`: Get a list of files you've changed since you last committed
* `git add <file or directory>`: Add a file or directory to the list of files that will be added to the next commit
* `git commit -m "commit message"`: Commit your changes to the current branch
* `git branch`: Get a list of branches on your machine
* `git branch branch-name`: Make a new branch called branch-name which contains all of the commits of the current branch
* `git push origin branch-name`: Send the current branch to brigade, and call it branch-name
* `git pull origin branch-name`: Update the current branch with the latest changes from branch-name on brigade
* `git log`: Get a list of the commits in the current branch
* `git grep <regex>`: Find all occurrences of regex in the current branch
* `git log --pickaxe-regex -S<regex>`: Find all of the commits on the current branch whose changes match regex
* `git branch -r --contains <commit>`: Find all of the branches that contain the given commit
* `git blame <file>`: Find out who changed what on file
* `git stash`: Move your uncommitted changes onto the stash queue
* `git stash apply`: Pop the latest stash off the stash queue and apply it to the current working copy
* `git reset --hard`: Permanently erase all uncommitted changes
* `git checkout branch-name`: Switch to branch-name
* `git fetch`: Download all of the branches that are on brigade
* `git branch -r`: Get a list of all branches, including the ones that are on brigade
* `git merge branch-name`: Merge the branch called branch-name into the current branch
