#Adding a Language
Follow these instructions in order to add a new language to be translated on web
and web-client.

Before any of the following is done, make sure the Localization Manager is aware of the new language that is being added.

1. From the [Smartling Dashboard](https://dashboard.smartling.com/translations/dashboard.htm), add the language so that translators will actually translate into that.
1. Make sure there is a row for the language in the `Translation` model so we have its english name, name in native language, and abbreviation.
1. Modify [`/config/initializers/locales.rb`](https://git.xarth.tv/web/web/blob/master/config/initializers/locales.rb), adding the language mapping from our abbreviations to [Smartling's abbreviations](https://dashboard.smartling.com/settings/api.htm) so the strings will actually get put into the `TransPhrase` model.
1. Add the language abbreviation to `config.i18n.available_locales` so that we can be allowed to set `I18n.locale` to it, and actually render content in that language.
1. Consider adding the language to the `broadcast_language_options` so that we can allow people to say their highlights are in that language.
1. Consider adding the language to `BroadcasterLanguage` languages so that we can allow people to say they are broadcasting in the language.
1. Add the locale in web-client in [i18n.config.json](https://git.xarth.tv/web/web-client/blob/master/i18n/i18n.config.json).
1. During the time Ember App is being transitioned from Rails to Web-Client, the locale needs to be added to the hard coded list in the server.go file.
1. The LoL Metadata experiment feature adapts localization codes to interface with an external source. As a result, manual curation is needed [here](https://git.xarth.tv/web/web-client/blob/5a0738cac068cc707356960b978950558902755f/app/services/lol-metadata-filter.js#L11) following the [Riot documentation](https://developer.riotgames.com/static-data.html).
