#Internationalization Pipeline

Please read the [Localization Process - Web](https://twitchtv.atlassian.net/wiki/display/ENG/Localization+Process+-+Web) Confluence page first -- a LOC JIRA ticket must be opened for a translation to start!

**There is a new process for Web Client, please read more about it [here](https://twitchtv.atlassian.net/wiki/pages/viewpage.action?pageId=164206952).**

##Overview
1. [Localization Process](#localization-process)
1. [Code Has The Translations And Swaps Out English
   Strings](#code-has-the-translations-and-swaps-out-english-strings)

## Localization Process

Read the [I18n instructions](https://git.xarth.tv/web/web/blob/master/i18n/README.md). Also, read this [wiki page](https://twitchtv.atlassian.net/wiki/pages/viewpage.action?pageId=100663412) to learn about how to create the JIRA ticket and let our localization manager process the strings. After the strings have been translated, proceed to the next step to download them.

## Code Has The Translations And Swaps Out English Strings
After bootup, the translations are stored in `TranslationsStore`. Ruby uses the translations through the `_()` function to swap out English strings for
translated strings. We pass the JavaScript flagged strings to
[web-client](https://git.xarth.tv/web/web-client) [here](https://git.xarth.tv/web/web/blob/master/app/views/shared/_translations.html.erb).
Javascript uses the `i18n()` function to swap out English strings for translated
strings.

See the [internationalization doc](internationalization.md) for a more nuanced look at how to write
internationalizable code.

## Debugging/Troubleshooting

[Slack Conversation](https://twitch.slack.com/archives/web/p1455836580000695)
