## Translation Pain Points 
Max's ramblings. TODO: Clean this up, identify clear action items

#### Three sources of strings: Smartling, Phrase table, template
This is especially problematic when you have to make changes. When you update a Phrase and send it to Smartling, a new phrase to translate is added to Smartling. When the translation is complete, the TransPhrase generated will have the same phrase_id (association with the original Phrase) but have a new version number.

If you want to revert an update to a Phrase, you must send the updated phrase before fetching translations from Smartling, otherwise your reverted Phrase will pull the translation of the updated Phrase, i.e., version 1 of the Phrase will end up being a key to get the translated version of version 2.

#### No easy way to check that everything matches except good ol' ctrl+f.
I've been using: `Phrase.where(:phrase => <copied and pasted string from template or smartling>)` to verify a match between two of the three sources of strings, and then using `TransPhrase.where(:phrase_id => <aforementioned phrase ID>)` to verify the third. This is prone to error, especially if there's a stray white space in the original Phrase.

Making templates refer to IDs or some other key identifier instead of using the actual string should alleviate a lot of this pain.

#### No concept of projects
If you want to double check all the strings for a given project, you have to simply examine them manually, either visually or via a console (`i18n` in JS, `TransPhrase.translate` in Rails), one at a time. Adding a column to Phrase, either a string (`whisper_project` or another table id, `Project` or whatever) will enable engineers to batch translate and review strings.

#### Translators don't respect placeholders 100% of the time
Styling requires use of `$$` for style placeholders, `%{}` for placeholders in rails generated templates, and `{{}}` for placeholders in Moustache/ich templates. Some or all of these are checked for in the translated string, so if placeholders are present in the original string but not the translated one, the translated string will **not** be saved.

The vendor must be careful to respect the placeholders used, and we should use placeholders very sparingly (there is already a risk of ordering being thrown out of whack if more than two placeholders of the same kind are used in a single phrase).

We should consider more flexible placeholder rules -- having an unstyled string at times may be preferable to no translation at all.

#### Translations versioning
We currently can't update an English phrase independently of other languages. If we want to make a minor change to English, but still display translations of older versions of a Phrase for other languages (while translations are being made), we can't do that.

#### Rejecting incomplete translations (over a project)
We want to avoid half-localized features. i.e. if nine of the ten strings we need are translated, we may want to avoid translating the nine strings entirely so we have it all in English, rather than an awkward mix of translated and non-translated. However, we have no concept of projects, or ability to reject specific strings for specific languages. Ideally we'd be able to say, only show translated versions of strings if the entire project is translated for that language.

#### Caching
I've had success with:
```
# In rails console
Rails.cache.clear
TransPhrase.reinitialize_languages
```
At this point, `TransPhrase.translate` should have new messages. You'll have to restart the server to see it on the actual pages (`rails s` or `zeus s` again, no need to do `zeus start`. For staging/prod, you'll probably need to redeploy).

#### Obsolete Strings
Once upon a time, a script ran that would make strings obsolete if they had since been removed from the codebase, and make them non-obsolete if they returned to the codebase.

This script has since stopped running regularly. It doesn't work anymore. Just be aware that obsolete strings will NOT be sent to smartling when you run `sync_phrases`.
