Original notes: https://docs.google.com/document/d/1_-KdopY1B7Z7zEAmO8C6DNJBIisUWlKLnJt-3i4tdu4/edit

**Warning**: Pre-localization is currently very painful and very hard to do.

For engineers, also see the [internationalization docs](internationalization.md)

A new I18n process has been made for Web-Client, please read more about it [here](https://twitchtv.atlassian.net/wiki/pages/viewpage.action?pageId=164206952). The below is not applicable to Web Client anymore.

**TODO**: Add notes for Liquid (CMS email templates).

#Feature Pre-Localization Workflow
#### Finalize the list of strings for the feature
This is mostly just marketing, legal, product coming together.

Things to consider:
* Styling: Translated strings in JS cannot be styled (i.e., contain links, have individual words be bolded, etc).
  * This is usually worked around by submitting sentence fragments to Smartling: `Contact us at` vs. `Contact us at $help@twitch.tv$`.
* Multiple styles in a single phrase: There is a risk that ordering may change from English, applying the wrong styles (linkifying a word that was supposed to be bolded). It is unclear how the vendor handles this.

#### Make strings i18n ready
##### Rails Pages
* Variable placeholders are wrapped in `%{}`, e.g. `My name is %{name}`

**NOTE**: These variable names have to correspond with actual variable names in code (i.e., `%{@channel.name}` vs `%{name}`). You may have to work with an engineer in coming up with these strings, or wait until code is relatively finalized before adding the strings to Phrases or sending it to the vendor.
* Styled phrases are wrapped in `$$`, e.g. "This is a **bolded** i18n string" => `This is a $bolded$ i18n string`.

**NOTE**: Be aware that ordering is not guaranteed across translations for phrases with multiple styles.
##### Ember Pages
* Variable placeholders are wrapped in `{{}}`, e.g. `My name is {{name}}`.

**NOTE**: In additional to the caveats listed above for Rails, be aware that these phrases are **NOT** interchangeable. If the same phrase with placeholder variables need to be used in both Rails and Ember, you must input the string twice, once with `%{}` and once with `{{}}`

(Unless you use ICH templates)

#### Other things to be careful of:
* No extra whitespaces. Seriously, it will ruin your day.

**TODO**: Phrases should have whitespaces trimmed before saving.

## Add phrases to the Phrase table using the Admin panel
For phrases to be used in Ember, make sure to check the `used in js` checkbox, otherwise these phrases will not be translated in Ember. On the other hand, please avoid checking `used in js` for phrases that will not be used in Ember pages, as it will unnecessarily increase the number of phrases passed into Ember.

## Send phrases to Smartling
Once you have added all the phrases you'd like translated.  You can click on the button in the sidebar of the phrases admin panel labelled `Upload phrases to Smartling`  This will upload the strings file to Smartling.  You will have to create a job in smartling after approving the phrases to start the translations.

## Get translated strings from Smartling
Once the strings have been translated by Smartling you can start the process of importing the strings files for all the locales that web supports.  You do this by clicking `Download translations from Smartling` in the sidebar in the phrases admin panel.  This will kick off a bunch of jobs for importing each language.  You will be emailed about the status of each langauge (sorry for the spam).

**NOTE**: This has taken less than 15 minutes for me. - Max

**NOTE**: For immediate results on staging environments, you want to these jobs from a staging admin panel as well.  You will not receive emails during the process.  Or if you can wait the translated strings should be replicated to Staging within two days of prod.

## Updating Strings
If it turns out you failed to completely predict the future, update the Phrase in the Admin panel and then:
* Let engineering or design know to update the phrase in the code/templates.
  * Updating the Phrase in the admin panel does not mean it will be reflected in code or on the site. The Phrase table is only used to send and download strings to and from Smartling.
* Update any documentation.
* Let Marketing and Product know (presumably they pushed for the change, but they should also be made aware of the timing).
* Click `Upload phrases to Smartling` in the admin panel
* Once translations are updated, click `Download translations from Smartling` in the admin panel.

```
## Open questions
* Turn around time for translations from vendor?
* Platforms?
* Cache? (1 day?)
* ADD ANY MISSING STEPS
* Planning guidelines?
