## Running Puppet

#### On all Rails production app/worker/crono boxes

##### Get list of all app boxes
```bash
consul-search -services web-rails-app -tag clean-production -format line > rails-app.txt
```
##### Get list of all worker boxes
```bash
consul-search -services web-rails-worker-hutch -tag clean-production -format line >> rails-app.txt
```
##### Get list of all crono boxes
```bash
consul-search -services web-rails-crono -tag clean-production -format line >> rails-app.txt
```
##### Run puppet on these boxes using `pssh`
```bash
pssh -O StrictHostKeyChecking=no -h rails-app.txt -l aaanwar -t 0 -p 50 -i 'sudo puppet agent --test'
```

###### Note:
1. Replace `aaanwar` in the above command with your user name.
2. If you don't have ssh keys set up, you'll have to pass `-A` to `pssh` to prompt you for password.
3. To run puppet using a branch instead of master, add `--environment <branch-name>` after `sudo puppet agent --test`
