# Rabbit
RabbitMQ is our message queue. It is how we fire asynchronous jobs in Rails. Things that can be resource intensive and
do not need to be run on user time can be put into a worker to be run later. Examples are things like sending emails,
updating the user's login time when they login, and syncing our cached follower counts with the actual follower
counts.

All our workers are in the web codebase in /script/workers/*_worker.rb. If you want to create a new worker, create a
new file in here and copy the layout of an existing worker.

## How do I use it?
There are two sides of Rabbit, producing jobs and consuming jobs. Producing a job is easy:

```ruby
Workers.publish(<worker_name>, <json_arguments>)
```

This tells Rabbit to add a job to its queue. However, if you don't do anything to consume the job, your job will stay
untouched in the dev queue. To process Rabbit jobs locally, run

```ruby
script/runner script/workers/run.rb --suffix=dev
```

This creates a worker that watches the dev rabbit queue. The worker processes jobs as long as the queue is not
empty.

We use the same Rabbit cluster for all environments, so please be sure to have --suffix=dev or you will consume
production jobs (on staging the suffix is "staging", and prod has no suffix). For email queues, you have to add
`--worker-type=email` for jobs to be consumed.

## How is our Rabbit setup?
You know what Rabbit is and what you should use it for. That should cover most things. If you have to dig deeper,
start by looking at the Rabbit code in Rails at `/lib/workers.rb`.

Our Rabbit setup contains one exchange and one queue per environment. The exchange is passed the current environment
and sends the job to the correct queue. If that doesn't make any sense please read [RabbitMQ's getting started
guide][1].

And check out the actual live Rabbit config

Let's look at an example of the lifecycle of a job in development. On development, when the producer publishes a
`message throughWorkers.publish()`, it gets sent to the exchange for the environment you are in, named
rails_workers.dev. The exchange is of type "fanout" so it sends all jobs it receives to all queues that are bound to
it, which in this case is only the rails_workers.dev queue. Presto, we have a job in the dev queue! As for
consuming, /script/workers/run.rb calls Workers.listen() and whenever the queue is not empty it process a job. It
knows what job to run because its :routing_key is the name of the worker to be run.
Also there is a distinction between normal jobs and email jobs. Any job that matches `*.email` is an email job, e.g.
`video.live.tell_followers.email` matches, `video.live.callback` does not match, and `channel.email_subscribers`
does not match. Normal jobs get processed by 'app' boxes and email jobs get processed by 'mailapp'.

[1]: http://rabbitmq.com/getstarted.html
