# Secrets Management

We use [Sandstorm](https://git.xarth.tv/systems/sandstorm) for our secret management.

## How do I add a new secret?

### 1. Add a placeholder

To add a new secret, add the key to `production.json` and `staging.json` but use `null` as the value:

```
"fancy_service": {
  "username:" null,
  "password": null,
  "url": "https://fancyservice.example.com/"
}
```

Note that even though a username might not technically be a secret, it should be treated as such. This allows you to easily rotate username/password through Sandstorm.

### 2. Add the secret to Sandstorm

Next, add your secret using the [Sandstorm Dashboard](https://dashboard.internal.justin.tv/sandstorm):

![](images/sandstorm_create.png)

Use `web-rails` as Team Name, `app` as Service Name, and the full JSON path as Key Name. Repeat this for all environments (Staging, Production) and all secrets you would like to add.

### 3. Deploy the secret using Puppet

Add the name of your secret to [`secrets.pp`](https://git.xarth.tv/systems/puppet/blob/master/modules/twitchtv/manifests/app/secrets.pp) and run Puppet on all rails-app and rails-worker boxes.

## How do I change a secret?

You can change a secret through the [Sandstorm Dashboard](https://dashboard.internal.justin.tv/sandstorm). Sandstorm will wait a set "dwell period" (currently 60 seconds) before applying your changed secret. Everytime a secret changes, the dwell period is restarted. When the dwell timer reaches zero, all secrets are updated in unison. This allows you to easily change dependent secrets (such as username/password).

Once the secrets are updated, Sandstorm will automatically restart the Rails processes after a random delay (currently between 0 and 600 seconds).
