# How to measure db in/out for master/slaves

Replace config/unicorn.conf.rb with this (don't commit, just use this for testing):

```ruby
cur_path = ENV['RAILS_PATH'] || Dir.pwd
nb_workers = ENV['NB_UNICORN_WORKERS'].to_i
worker_processes(nb_workers)
```

Spin up 10 processes to receive incoming API hits:
```
NB_UNICORN_WORKERS=10 RAILS_ENV=production_direct bundle exec unicorn -c config/unicorn.conf.rb
```

Use `iftop` to measure bandwidth in/out of databases.
```bash
sudo iftop
```

In iftop, press `l` then type regex (like `db`) to filter results. You can press `P` to freeze the display when you want
to stop it from continuing to update. In the `production_direct` environment, `db24` is your slave and `dbproxy1` is your master.

Then do work against these API endpoints:
```bash
wrk --connections 20 --duration 60s --threads 20 http://0.0.0.0:8080/kraken/videos/followed?oauth_token=`cat ~/Dropbox/follows`
```
