# Making test purchases
You can test credit cards using the number `4111 1111 1111 1111`. You must use a CVV consisting of three numbers 0-9 and a fullname in firstname lastname format. The script doesn't matter what they are, so long as they are there. Here's how the environment is setup:

| Environment     | Database    | Payment    |
|:----------------|:------------|:-----------|
| Development     | Development | Sandbox    |
| Staging         | Development | Sandbox    |
| Production      | Production  | Production |

This is straightforward, but realize that if you use the sandbox payment system to buy stuff on hot development or staging, you will be affecting the accounts on the production database server. Here are some more card numbers you might need if you're working on the payment system:

General testing card #s:

| Card number      | Card brand       |
|:-----------------|:-----------------|
| 370000000000002  | American Express |
| 6011000000000012 | Discover         |
| 5424000000000015 | MasterCard       |
| 4007000000027    | Visa             |

For special testing: "for example, to test the AVS response reason code number 27, submit the test transaction with the credit card number “4222222222222” and the amount “27.00.”"

## PayPal

When you select the Paypal method, it will ask you to log into a sandbox- this isn't what normal users will see. You need to log in to paypal as one of these OR create your own test user from the sandbox page:

![](http://i.imgur.com/TLjkrH5.png)

| Email address                  | PayPal password |
|:-------------------------------|:----------------|
| renee_1260213346_per@justin.tv | testpaypal      |
| cait_1308850592_per@justin.tv  | testpaypal      |

After logging in, go ahead and perform the payment. The two accounts have enough money for anything.

To create your own test user or manage the developer account, log into https://developer.paypal.com with these credentials:

| Email address          | PayPal password  |
|:-----------------------|:-----------------|
| payments-dev@justin.tv | QAPaypalSandbox! |

## General PROTIPs

* Rails.logger.{debug level} is your friend
* Follow these steps:
  1. ssh into staging (`[username]@app998.sfo01.justin.tv`)
  2. run `sudo su – jtv`
  3. navigate to ~/staging/current/log
  4. `grep "whatever" *.log`
* If you trigger a log statement via the rails console, it seems to log into staging.log, whereas log activity originating from the actual website seems to be dumped into railsN.log
* Mixpanel events can be "tested" by checking the user's "mixpanel_profile" association
* Certain events, such as interactions with foreign APIs, can only occur on beta (since staging is restricted to our internal network). the subdomain for beta is `app999`
