# Tests

## rspec

### In parallel

#### 1. Install postgres from brew
```bash
brew tap petere/postgresql
brew install postgresql@9.3
brew link -f postgresql@9.3
```

#### 2. Set up testing environment
You only need to do this once.

```bash
initdb postgres # creates directory for databases - 'postgres' is in .gitignore for web/web
pg_ctl -D postgres -l tmp/logfile start

# Optional step: gets schema from staging dbs, currently broken
# bundle exec rake db:structure:dump
TWITCH_TEST_LOCAL=1 bundle exec rake parallel:prepare # Make local test databases from db/structure.sql
```

#### 3. Run the tests
```bash
# add `export TWITCH_TEST_LOCAL=1` to your ~/.bash_profile file 
# so you don't have to keep setting it every time you run tests

TWITCH_TEST_LOCAL=1 bundle exec zeus start # in separate terminal
TWITCH_TEST_LOCAL=1 bundle exec zeus parallel_rspec spec engines/*/spec
```

If you get test failures, you may want to try running this way to run tests in parallel without zeus:
```
RAILS_ENV=test TWITCH_TEST_LOCAL=1 bundle exec rake parallel:forked_parallel_tests
```

Zeus lets you run commands w/out waiting for the rails startup (zeus rake routes). Check out the docs/Development.md for more details.

## API Endpoint Validator

We use the [API Endpoint Validator](https://git.xarth.tv/release/validator) to ensure the public API does not change without our knowledge.

### Installation

The API is automatically validated as part of the build process (as integration test via `rspec`). It uses a Ruby gem for the validation during the build process and does not require any additional external dependencies. However, if you want to update the expected results or run the validator manually (see below) you need to install the [API Endpoint Validator](https://git.xarth.tv/release/validator):

1. `git clone` the validator repository (we assume that you clone it to `~/twitch/validator` but you are free to choose a different path)
2. `cd` into the validator repository that you just cloned
3. Run `./run_validator.sh` and enter your local admin password when prompted
4. Run `export TWITCH_API_VALIDATOR_HOME=~/twitch/validator` (and add it to your `.bash_profile`)

### Endpoints

The endpoints to be validated are listed in `test/api/endpoints.json.erb`. If you change this file, you need to update the *Expected Results* (see below).

### Expected Results

The files `test/api/expected_results/*/get/results.json` contain the [JSON Schema](http://json-schema.org/) for all the endpoints that are tested. This file can (and should be) automatically generated with the following command:

```bash
bundle exec rake api_validator:generate_results_template['https://api.twitch.tv']
```

**Note:** Replace `https://api.twitch.tv` with `http://staging-$id-api.dev.us-west2.twitch.tv` to record results from staging or `http://localhost.twitch.tv:3000` to record the results from the local development server.

### Full-stack testing

The integration tests that run as part of the build use [`RackTest`](https://github.com/jnicklas/capybara#racktest) and interact directly with the Rack interfaces (without an actual application or web server). To run the tests against a full-stack server, use this command:

```bash
bundle exec rake api_validator:run['https://api.twitch.tv']
```

Again: Replace `https://api.twitch.tv` with the server to be tested (`http://localhost.twitch.tv:3000` for a local development server, `http://staging-$id-api.dev.us-west2.twitch.tv` for staging, …)

## UI testing with Capybara

### What is a User Interface Automated Test?
A user interface automated tests make sure the website is functioning as intended. Services such as login, page loading, and proper interaction with elements can be confirmed with these tests. 

### What is a Smoke Test?
Smoke tests are run to make sure the most basic functions of a web application are functioning as intended. It does not give granular detail of what caused the problem, like in a unit tests, but conveys that if there is smoke, there may be a fire. 

### What is Capybara?
Capybara is a high level integration testing framework that abstracts the webdriver and browser used, it is written in Ruby. 

### Testing post deploy
Currently anytime someone pushes code to staging, staging2, and beta, these tests are run by a Jenkins job: http://jenkins.internal.twitch.tv/job/qa-smoca ( Note: production jobs are not post deploy, as they run continuously) 

### Continuously running tests
Currently the tests are running continuously against production http://jenkins.internal.twitch.tv/job/qa-smoca-lambchops

### What happens to failed tests?
A failed test will not prevent someone from pushing code to an environment, as these are post deploy. Currently only notifications of failed tests are sent to the Slack rooms ( qa-automation for post deploy of staging and beta, and qa-automation-production for production). Once these tests become more stable and reliable, we will talk about sending these notifications to on call, if desired. When we move to individual branches for each developer it would make sense for the owner of that specific branch to also be notified. 

### How can I see failed tests?
1. Visit "qa-automation" for staging and beta post deploy tests and "qa-automation-production" for production continuous testing
2. Click on a Jenkins failed test link that is highlighted in red
3. Click on 'Console Output' from the jenkins page
4. Scroll to bottom to see Rspec output from Capybara 

The user interface automated tests are currently kept in the capybara folder of the web/web repo and qa/smoca. 

### Steps to run the tests against staging from a local computer:
CD into root directory of qa/smoca repo
run "bundle install"
run "bundle exec rspec"

### Steps to run the tests against production from a local computer:
"CAPYBARA_APP_HOST=production bundle exec rspec"

### Steps to run the tests against local dev environment from a local computer:
While running the Web app locally:
"CAPYBARA_APP_HOST=local bundle exec rspec"

### Coverage:
For a list of tests are running, or about to be run, please visit [this Google Doc][1]. Some of the tests on master are expected to break right now until they are updated. 

[1]: https://docs.google.com/a/justin.tv/spreadsheets/d/1HAPjM6SUK4u7rEkr-RIgTnREOMDMwpxfYEU9jyrKQrk/edit#gid=0
