# Video on demand

*See also: [video/vod](/video/vod.md)*

A **video on demand** (commonly **VOD** or **VoD**) is a piece of [video](/video/README.md) that isn't [live](/video/live.md). Usually it was live at one point, and was stored as a past broadcast or highlight for later playback.

## Past Broadcasts
Each live broadcast is written to disk in discrete chunks. Each chunk is an .flv stored on one or more media boxes, and is represented by a row in the archives table. Archives from the same broadcast are linked via the 'broadcast_id' field, and are ordered via 'broadcast_part'.

## Vod Deletion
Highlights are always saved forever. Past broadcasts are deleted after 14 days. The exception is if you are a partner or if you are Turbo, in which case your past broadcasts get deleted after 60 days. The code that handles this is located here: https://git.xarth.tv/web/web/blob/master/engines/vod_service/app/repositories/vod_service/vod_repository.rb#L195
In addition, channels can be marked `save_vods_forever`, which prevents all vod deletion on that channel.

## Highlight
A highlight is a contiguous segment of video cut from a broadcast. Creating a new highlight does not create any new video files on disk. A highlight is a set of metadata and a playlist file that point to the set of files to be played back. Highlights are saved forever
Highlighting
Authorized users (i.e. the original broadcaster and his editors) may create highlights from past broadcasts. Content is always owned and played back on the original broadcaster's channel.

## Uploads
We are working on building a 3rd vod type, uploads, which is simply vod files that are manually uploaded by broadcasters.

## APIs
VOD data is currently stored in sitedb but is either exposed privately through internal API and videoshim, or publicly through Kraken.
