# Vod Appeals API

Broadcasters have the ability to appeal vods by selecting from a list of muted tracks. Admins can then access these vod appeals from admin, unmute selected tracks from that vod appeal, and resolve both the track appeals and the vod appeals. An email will then be sent to the user upon vod appeal resolution. 

Reasons that a user cannot appeal a vod are:
  - The vod is not muted
  - The user is not the owner of the vod (only the broadcaster can appeal a vod)
  - A pending vod appeal already exists for this vod
  - All of the vod's tracks have already been appealed (regardless of its muted/unmuted state)

Tracks are shared amongst a vod's archive and its highlights (see [audible magic responses](../audible_magic_responses)).

## Vod Appeals schema

```ruby

# == Schema Information
#
# Table name: vod_appeals
#
#  id          
#  resolved_at 
#  created_at  
#  updated_at  
#  full_name
#  street_address_1
#  street_address_2
#  city
#  state
#  zip_code
#  country
#  vod_id      | this vod_id can belong to either a highlight or a past_broadcast
#
# Indexes
#
#  index_vod_appeals_on_vod_id  (vod_id)
#
```

```ruby
# == Schema Information
#
# Table name: track_appeals
#
#  id                        
#  audible_magic_response_id  | each audible_magic_response can have at most one track_appeal associated with it
#  vod_appeal_id              | each vod_appeal has at least one track_appeal
#  reason                    
#  created_at                
#  updated_at                
#  resolved_at                
#
# Indexes
#
#  index_track_appeals_on_audible_magic_response_id  (audible_magic_response_id)
#  index_track_appeals_on_vod_appeal_id              (vod_appeal_id)
#
```

## API

### Getting a vod's muted tracks (and track appeal status)
```js
GET api/vods/:vod_id/muted_tracks
[
  {
    "id": 71797849,
    "title": "Only Girl (In The World)",
    "performer": "Rihanna",
    "is_muted": true, // do we need this?
    "offset": 0,
    "duration": 32,
    "track_appeal":  {
      status: 'pending', // one of 'pending', 'approved', or 'rejected'
     	reason: ’fair_use’
  	}
  }
]

```

### Creating a vod appeal
Required parameters: 
- track_appeals (ids are the amrids returned from muted_tracks and must belong to the vod_id) 
- full_name
- country
- city
- street_address_1
- reason (one of [:incorrect_match, :public_domain, :original_content, :permission_rights, :fair_use])
```js
PUT api/vods/:vod_id/create_appeal
{ 
  track_appeals: {
     ":track_id": "reason",
     ":track_id": "reason" 
  },
  full_name: "full name",
  street_address_1: "street address 1",
  street_address_2: "street address 2",
  city: "city",
  state: "state",
  zip_code: "zip code",
  country: "country"
}

```

### Getting vod appeals metadata for multiple vods
Required parameters:
- vod_ids

```js
PUT /api/vod_appeals?vod_ids=2884448, 2888888
[ 
  {
    can_create_appeal: false,
    can_view_appeal: true,
    has_pending_appeal: true,
    is_muted: true,
    vod_id: 2884448
  }
]
