package main

import (
	"fmt"
	"io"
	"strings"

	"github.com/urfave/cli"
)

type completes struct {
	cons *consulHelper
}

func (d *completes) teamComplete(c *cli.Context) {
	teams, err := d.cons.teams()
	if err != nil {
		d.handleCompletionError(c.App.Writer, err)
		return
	}
	fmt.Fprintln(c.App.Writer, strings.Join(teams, "\n"))
}

func (d *completes) teamServiceEnvComplete(c *cli.Context) {
	if c.NArg() == 0 {
		teams, err := d.cons.teams()
		if err != nil {
			d.handleCompletionError(c.App.Writer, err)
			return
		}
		fmt.Fprintln(c.App.Writer, strings.Join(teams, "\n"))
		return
	}
	team := c.Args().Get(0)
	if c.NArg() == 1 {
		services, err := d.cons.teamServices(team)
		if err != nil {
			d.handleCompletionError(c.App.ErrWriter, err)
		}
		fmt.Fprintln(c.App.Writer, strings.Join(services, "\n"))
		return
	}
	service := c.Args().Get(1)
	if c.NArg() == 2 {
		team := c.Args().Get(0)
		envs, err := d.cons.serviceEnvs(team, service)
		if err != nil {
			d.handleCompletionError(c.App.Writer, err)
		}
		fmt.Fprintln(c.App.Writer, strings.Join(envs, "\n"))
		return
	}
}

func (d *completes) handleCompletionError(out io.Writer, err error) {
	d.Errorf(out, fmt.Sprintf("Invalid bash completion: %s", err.Error()))
}

func (d *completes) Errorf(out io.Writer, a ...interface{}) {
	fmt.Fprintln(out, a...)
}
