package main

import (
	"fmt"
	"io"

	"github.com/aws/aws-sdk-go/service/iam"
	"github.com/urfave/cli"
)

type logger struct {
	awsapi     *awsapi
	verboseOut io.Writer
}

func (d *logger) verboseLogYourself(c *cli.Context, deploymentInfo *deploymentInfo) error {
	if c.GlobalBool("verbose") {
		iamClient, err := d.awsapi.getIAMClient(deploymentInfo.Region, "", deploymentInfo.Profile)
		if err != nil {
			return err
		}
		whoIsMakingRequest, err2 := iamClient.GetUser(&iam.GetUserInput{})
		if err2 != nil {
			return err2
		}
		fmt.Fprintln(c.App.ErrWriter, whoIsMakingRequest.User.String())
	}
	return nil
}

func (d *logger) verbose(c *cli.Context, values ...interface{}) {
	if c.GlobalBool("verbose") {
		fmt.Fprintln(d.verboseOut, values...)
	}
}
