package main

import (
	"fmt"
	"github.com/aws/aws-sdk-go/aws/endpoints"
	"os"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/urfave/cli"
)

type deployerApp struct {
	app          *cli.App
	completes    completes
	pipeline     pipelineCommand
	consulHelper consulHelper
	ecsCommand   ecsCommand
	awsapi       awsapi
	logger       logger
}

var instance = deployerApp{
	app: cli.NewApp(),
}

func main() {
	instance.main()
}

func (d *deployerApp) main() {
	d.awsapi = awsapi{
		coreConfigs: []*aws.Config{
			{
				Logger: aws.LoggerFunc(func(v ...interface{}) {
					fmt.Fprintln(d.app.ErrWriter, v...)
				}),
				CredentialsChainVerboseErrors: aws.Bool(true),
				STSRegionalEndpoint: endpoints.RegionalSTSEndpoint,
			},
		},
	}
	d.completes = completes{
		cons: &d.consulHelper,
	}
	d.logger = logger{
		verboseOut: os.Stderr,
		awsapi:     &d.awsapi,
	}
	d.ecsCommand = ecsCommand{
		completes:    &d.completes,
		consulHelper: &d.consulHelper,
		awsapi:       &d.awsapi,
		logger:       &d.logger,
	}
	d.pipeline = pipelineCommand{
		completes:    &d.completes,
		consulHelper: &d.consulHelper,
		logger:       &d.logger,
		awsapi:       &d.awsapi,
		in:           os.Stdin,
	}
	d.app.Authors = []cli.Author{
		{
			Name:  "Jack Lindamood",
			Email: "jlindamo@twitch.tv",
		},
	}
	d.app.Name = "ecs-deploy"
	d.app.Usage = "Deploy helper for ECS promotion pipelines"
	d.app.Version = "0.1"
	d.app.EnableBashCompletion = true
	d.app.ErrWriter = os.Stderr
	d.app.Writer = os.Stdout
	d.app.Flags = []cli.Flag{
		cli.BoolFlag{
			Name:  "verbose",
			Usage: "Enables verbose output",
		},
	}
	d.app.Commands = []cli.Command{
		d.pipeline.subcommands(),
		d.ecsCommand.subcommands(),
	}
	if err := d.app.Run(os.Args); err != nil {
		os.Exit(1)
	}
}
