package main

import "text/template"

const fullStatusTemplateText = `{{ .Center " Status " }}
Status:      {{ .ConsulStatus }}
Team:        {{.Team}}
Service:     {{.Service}}
Environment: {{.Env}}
Version:     {{.DeployedVersion}}
PromoteFrom: {{.PromoteFrom}}
FromVersion: {{.PromoteFromVersion}}
{{ if  not .Short }}{{ .Center " Terraform state " }}
{{ range $key, $value := .TerraformState -}}
   {{ $key | printf "%-20s" }} : {{ $value }}
{{ end -}}
{{ end -}}
{{ .Center " Service state " }}
Cluster:     {{.ECSService.ClusterArn}}
Status:      {{.ECSService.Status}}
Task:        {{.ECSService.TaskDefinition}}
Deployments: {{len .ECSService.Deployments}}
Running | Pending | Desired
{{ .ECSService.RunningCount }}       | {{.ECSService.PendingCount }}       | {{.ECSService.DesiredCount }}
`

var fullStatusTemplate = template.Must(template.New("status_template").Parse(fullStatusTemplateText))

const defaultTaskTemplateText = `{
  "networkMode": "bridge",
  "taskRoleArn": "{{.task_role_arn}}",
  "containerDefinitions": [
    {
      "portMappings": [
        {
          "containerPort": {{.container_port}},
          "protocol": "tcp"
        },
        {
          "containerPort": 6060,
          "protocol": "tcp"
        }
      ],
      "essential": true,
      "name": "{{.task_name}}",
      "readonlyRootFilesystem": true,
      "image": "{{.image}}",
      "logConfiguration": {
        "logDriver": "awslogs",
        "options": {
          "awslogs-group": "{{.container_loggroup}}",
          "awslogs-region": "{{.container_loggroup_region}}",
          "awslogs-stream-prefix": "{{.environment}}"
        }
      },
      "environment": [
        {
          "name": "ENVIRONMENT",
          "value": "{{.environment}}"
        },
        {
          "name": "GIT_COMMIT",
          "value": "{{.git_commit}}"
        }
      ],
      "ulimits": [
        {
          "name": "nofile",
          "softLimit": {{.ulimit_nofile}},
          "hardLimit": {{.ulimit_nofile}}
        }
      ],
      "cpu": {{.task_cpu}},
      "memoryReservation": {{.task_mem}}
    }
  ],
  "family": "{{.task_family}}"
}`

var _ = template.Must(template.New("default_task").Parse(defaultTaskTemplateText))

const runningTaskTemplateText = `Here are the logs:
Task ARN: {{.TaskARN}}
Status: {{.Status}}

{{ range $key, $value := .Containers }}
	Logs: {{$.ContainerLogs $key }}
{{ end }}
`

var runningTaskTemplate = template.Must(template.New("running_tasks").Parse(runningTaskTemplateText))

const awsCredsText = `[default]
aws_access_key_id = {{.AccessKey}}
aws_secret_access_key = {{.Secret}}

[{{.Profile}}]
aws_access_key_id = {{.AccessKey}}
aws_secret_access_key = {{.Secret}}

[deploy_role]
role_arn = {{.RoleARN}}
source_profile = {{.Profile}}
`

var awsCredsTemplate = template.Must(template.New("aws_creds").Parse(awsCredsText))
