#!/bin/bash
set -ex

if [ -z "$TEAM" ]; then
  (>&2 echo "TEAM name not set")
  exit 1
fi

if [ -z "$SERVICE" ]; then
  (>&2 echo "SERVICE name not set")
  exit 1
fi

if [ -z "$TAG" ]; then
  (>&2 echo "TAG name not set")
  exit 1
fi

BUILD_PIPELINE_VERSION="v0.4.7"

function docker_run() {
  ADD_CONFIG_ENV=""
  if [ ! -z "$AWS_CONFIG_FILE" ]; then
    ADD_CONFIG_ENV="-e AWS_CONFIG_FILE=/awsconfig -v $AWS_CONFIG_FILE:/awsconfig:ro"
  fi
  echo 'docker run --read-only -u 61000:61000 -e AWS_SDK_LOAD_CONFIG=1 '$ADD_CONFIG_ENV' -v '$(pwd)':/twitch:ro docker.pkgs.xarth.tv'
}

$(docker_run)/twitch/ecs-deploy:$BUILD_PIPELINE_VERSION /ecs-deploy --verbose pipeline as-json $TEAM $SERVICE $TAG
