# twitch
The master repository for all twitch Go code.


Biggest changes:
* Replace multiple repositories with mono repository for all Go code
* Replace puppet with sidecar containers.  statsd/xray/etc per host applications with optional sidecar Docker containers with CPU/memory limitations
* Replaces skadi UI with a deployment pipeline using Jenkins pipelines
* Replaces courier with Docker containers
* Replace EC2 instances in ASG with ECS
* Replace ELB with ALB
* Replace terraform copy/pasta with common terraform service modules
* Replace twitch AMI with minimalist amazon built in AMI
* Replace per host permissions with per container permissions. The xray daemon has permission to talk to xray.  The other services on the host do not (and don't care about configuring those permissions)
* Replace jenkins.groovy with Jenkinsfile for on commit builds (TODO: https://marcesher.com/2016/06/21/jenkins-as-code-registering-jobs-for-automatic-seed-job-creation/)
* Builds all code on each commit and pushes it thru integration/staging/canary/production pipeline
* Each pipeline step has configurable check and rollback scripts with optional human intervention

# On each commit


1. Build code
2. Run unit tests
3. Build docker images with SHA
4. Push docker images with SHA to docker registry
5. If branch is master, tag image as latest (TODO.  Right now latest tag happens every time)
6. If branch is master, run master pipeline (usually starts integration tests)

# Pipeline (takes SHA1 tag as parameter)

If any step fails, revert to previous SHA1

1. Deploy SHA1 to environment
2. Wait for deploy to stabilize
3. Run tests for this pipeline
4. Wait for staging to stablize

# Deploy pipeline

If any step of the 4 steps of a deploy pipeline fail, the deploy is reverted

1. Take as parameter SHA1 to deploy
2. Deploy to environment
3. Wait for deploy to stablize
4. Run tests for stage



# Directory structure

## bin
Generally helpful scripts and binaries people can execute

## src
All the Go source code goes here.  All code should follow the same layout.

### src/team
Each team has their own src directory

### src/team/cmd
Every executable and main.go file for each team should be inside only their
cmd directory

### src/team/libname
Each library coexists with the team's cmd directory.  There should be no main.go
or executables inside libraries

## src/vendor
All non twitch Go code is placed inside the vendor directory and managed by _dep_
Dep generated files include Gopkg.lock and Gopkg.toml

## third-party
One off builds of docker containers needed for service upkeep and deployment.
These should generally be versioned.

## terraform
Terraform infra setups.  It is split by teams, similar to src.  Each team directory has exactly two
subdirectories, modules and environments.

## terraform/team
Terraform configs are split by team

## terraform/team/environments
Each team can have as many environments as it wants.  Usually there is a staging and production
environments.

## terraform/team/environments/env_name/environment_subset
Rather than have one big terraform for each environment, we split it into subsets. There is usually
one for each microservice.

## terraform/team/modules
Teams can create their own modules, usually one per microservice. 

## jenkins.groovy
Used to kick off the build in jenkins.  You should ideally not modify this file.

# Build process

All build is kept inside build.sh and has two phases.  The first phase runs manta.build
on every build.json file.  The second finds and runs all post-build.sh scripts.
You generally want to do heavy lifting inside manta.build and reserve post-build.sh
for creating Docker containers if you need them.



