#!/bin/bash
# Helps you download and run jenkins CLI commands

set -ex
export JENKINS_URL=https://jenkins.internal.justin.tv
export JENKINS_AUTH_FILE=~/.jenkins_auth
export JENKINS_CLI_PATH=/tmp/jenkins-cli.jar

if [ ! -f $JENKINS_AUTH_FILE ]; then
    echo "Unable to find jenkins auth file at $JENKINS_AUTH_FILE"
    echo "This file is needed to authenticate to jenkins to run cli commands"
    echo "You can download this information from your jenkins config page"
    echo "https://jenkins.internal.justin.tv/user/`whoami`/configure"
    echo "Click 'Show API Token'"
    echo "Move the 'UserID:API Token' to the file $JENKINS_AUTH_FILE"
    echo "You should have a file that looks like jlidamo:eeffadfdgd"
    exit 1
fi

if [ ! -f $JENKINS_CLI_PATH ]; then
    curl $JENKINS_URL/jnlpJars/jenkins-cli.jar > $JENKINS_CLI_PATH
fi

java -jar /tmp/jenkins-cli.jar -http -s $JENKINS_URL -noKeyAuth -auth @"$JENKINS_AUTH_FILE" $@
