#!/bin/bash
# Sets up recommended deployment pipeline for a project
# integration -> staging -> canary -> production
set -ex

TEAM=$1
PROJECT=$2
JOB_TEMPLATE="deploy/common/job_template.xml"

function verify_environment() {
  E=$1
  if [ ! -f "terraform/$TEAM/environments/$E/$PROJECT/main.tf" ]; then
    echo "unable to find terraform setup at terraform/$TEAM/environments/$E/$PROJECT/main.tf"
    return 1
  fi
  if [ ! -f "deploy/$TEAM/environments/$E/deploy.json" ]; then
    echo "Unable to find team deployment configuration in deploy/$TEAM/environments/$E/deploy.json"
    return 1
  fi
}

function create_template_file() {
  UPSTREAM=$1
  ENVIRONMENT=$2
  sed "s/%%%UPSTREAM%%%/$UPSTREAM/g" <"$JOB_TEMPLATE" | sed "s/%%%TEAM%%%/$TEAM/g" | sed "s/%%%PROJECT%%%/$PROJECT/g" | sed "s/%%%ENVIRONMENT%%%/$ENVIRONMENT/g" >"/tmp/$TEAM-$PROJECT-$ENVIRONMENT"
}

function create_or_update() {
  JOB=$1
  FILE=$2
  if jenkins-cli.sh get-job $JOB > /dev/null ; then
    CMD="update-job"
  else
    CMD="create-job"
  fi
  jenkins-cli.sh $CMD $JOB < $FILE
}

if [ ! -f "$JOB_TEMPLATE" ]; then
  echo "Unable to find job template file"
  exit 1
fi

# Verify jenkins cli works
jenkins-cli.sh who-am-i

verify_environment integration
verify_environment staging
verify_environment canary
verify_environment production

create_template_file twitch-gocode-trigger-deploy-pipeline integration
create_template_file $TEAM-$PROJECT-integration staging
create_template_file "" canary
create_template_file "" production

create_or_update $TEAM-$PROJECT-integration /tmp/$TEAM-$PROJECT-integration
create_or_update $TEAM-$PROJECT-staging /tmp/$TEAM-$PROJECT-staging
create_or_update $TEAM-$PROJECT-canary /tmp/$TEAM-$PROJECT-canary
create_or_update $TEAM-$PROJECT-production /tmp/$TEAM-$PROJECT-production

