#!/bin/bash
# Runs terraform plan, showing you the output, and waits for
# y/n confirmation before applying it

confirm() {
    # call with a prompt string or use a default
    read -r -p "${1:-Are you sure? [y/N]} " response
    case "$response" in
        [yY][eE][sS]|[yY]) 
            true
            ;;
        *)
            false
            ;;
    esac
}

FILENAME=$(mktemp -t terraform_plan)

rm -f $FILENAME  || exit 1
terraform init || exit 1
terraform plan -out $FILENAME  -detailed-exitcode
PLAN_CODE=$?

if [ $PLAN_CODE -eq 0 ]; then
  echo "No changes detected"
  exit 0
fi

if [ $PLAN_CODE -eq 1 ]; then
  exit 1
fi

confirm "Apply this change [y/n]: "
if [ $? -eq 1 ]; then
  echo "Not applying change"
  exit 1
fi
terraform apply $FILENAME
exit $?
