freeStyleJob('twitch-gocode') {
  using 'TEMPLATE-autobuild'
  scm {
    git {
      remote {
        github 'twitch/gocode', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }
  steps {
    shell './jenkins/build.sh'
    conditionalSteps {
      condition {
        shell 'test $GIT_BRANCH = "origin/master"'
      }
      runner('DontRun')
      steps {
        downstreamParameterized {
          trigger('twitch-gocode-trigger-deploy-pipeline') {
          }
        }
      }
    }
  }
}

// Downstream jobs can trigger on this to deploy when master is build
freeStyleJob('twitch-gocode-trigger-deploy-pipeline') {
  quietPeriod 0
  parameters {
    stringParam 'GIT_COMMIT'
  }
  steps {
    shell '''
cat <<EOF>commit.properties
GIT_COMMIT=\$GIT_COMMIT
EOF
'''
  }
  publishers {
    archiveArtifacts("commit.properties")
  }
}

