#!/bin/bash
set -ex

# https://stackoverflow.com/questions/59895/getting-the-source-directory-of-a-bash-script-from-within
DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"

. "$DIR/../jenkins/common.sh"

debug_info

function run_manta_builder() {
(
  # TODO: Skip even more builds if the image is already built
  cd `dirname $1`
  if [ -f "common.sh" ]; then
	  . common.sh
	  if [ "$(type -t should_skip_build)" = "function" ]; then
		  if should_skip_build ; then
			  echo "resolved to skip build for $1"
			  return
		  fi
	  fi
  fi
#  manta -update -v -f build.json
  manta -v -f build.json
)
}

function post_build() {
(
  cd `dirname $1`
  ./post-build.sh
)
}

if [ -z "$GIT_COMMIT" ]; then
  echo "GIT_COMMIT not set.  Cannot execute post build steps"
  exit 1
fi;

find . -name build.json | while read line ; do
  run_manta_builder $line
done

find ./third-party -name post-build.sh | while read line ; do
  post_build $line
done

find ./src -name post-build.sh | while read line ; do
  post_build $line
done
