#!/bin/bash

export CONSUL_HTTP_ADDR="consul.internal.justin.tv"

function docker_image_exists() {
  resp=$(curl --write-out %{http_code} --silent --output /dev/null https://docker-registry.internal.justin.tv/v2/$1/manifests/$2)
  [ $resp = "200" ]
}

function version_already_deployed() {
  TEAM_NAME=$1
  BINARY_NAME=$2
  VERSION=$3
  ENVIRONMENT=$4
  if [ -z "$ENVIRONMENT" ]; then
    ENVIRONMENT="latest"
  fi
  if [ "$(deployed_version $TEAM_NAME $BINARY_NAME)" == "$VERSION" ]; then
    docker_image_exists $TEAM_NAME/$BINARY_NAME $VERSION
    return
  fi
  return 1
}

function deployed_version() {
  TEAM_NAME=$1
  BINARY_NAME=$2
  ENVIRONMENT=$3
  if [ -z "$ENVIRONMENT" ]; then
    ENVIRONMENT="latest"
  fi
  rm -f .deploy_version
  if docker run -e CONSUL_HTTP_ADDR=$CONSUL_HTTP_ADDR consul kv get -datacenter us-west2 "pipeline/deployed/$TEAM_NAME/$BINARY_NAME/$ENVIRONMENT" > .deploy_version; then
    ret=$(cat .deploy_version)
    rm -f .deploy_version
    echo $ret
  else
    rm -f .deploy_version
    echo ""
  fi
}

function build_tag_push() {
  TEAM_NAME=$1
  BINARY_NAME=$2
  VERSION=$3
  DOCKERFILE=$4
  if [ -z "$VERSION" ]; then
    VERSION=$GIT_COMMIT
  fi
  if [ -z "$VERSION" ]; then
    echo "Unable to find set version"
    return 1
  fi
  if [ -z "$TEAM_NAME" ]; then
    echo "Unable to find set team name"
    return 1
  fi
  if [ -z "$DOCKERFILE" ]; then
    DOCKERFILE="Dockerfile"
  fi
  docker build -f $DOCKERFILE -t $TEAM_NAME/$BINARY_NAME:${VERSION} .
  docker tag $TEAM_NAME/$BINARY_NAME:${VERSION} docker-registry.internal.justin.tv/$TEAM_NAME/$BINARY_NAME:${VERSION}
  docker push docker-registry.internal.justin.tv/$TEAM_NAME/$BINARY_NAME:${VERSION}

  if [ "$GIT_BRANCH" == "origin/master" ]; then
    docker tag $TEAM_NAME/$BINARY_NAME:${VERSION} docker-registry.internal.justin.tv/$TEAM_NAME/$BINARY_NAME:latest
    docker push docker-registry.internal.justin.tv/$TEAM_NAME/$BINARY_NAME:${VERSION}
    docker run -e CONSUL_HTTP_ADDR=$CONSUL_HTTP_ADDR consul kv put -datacenter us-west2 "pipeline/deployed/$TEAM_NAME/$BINARY_NAME/latest" $VERSION
  fi
}

# Print out various debug info just to see what's
# going on in the build's shell
function debug_info() {
  pwd
  env
  hostname
  whoami
  date
  ls -la .
}
