#!/bin/bash
set -ex

# Print out various debug info just to see what's
# going on in the build's shell
function debug_info() {
  pwd
  env
  hostname
  whoami
  date
}

function each_team_cmd() {
(
  cd `dirname $1`
  NAME=$(basename $(pwd))
  go build -ldflags "-linkmode external -extldflags -static" -o $NAME .
  go build -race -ldflags "-linkmode external -extldflags -static" -o ${NAME}_race .
)
}

find . -type f -name main.go -not -path './vendor/*' | while read line ; do
  each_team_cmd $line
done

