package httprpc

import (
	"code.justin.tv/feeds/distconf"
	"code.justin.tv/feeds/service-common"
	"code.justin.tv/twitch/gocode/src/deploy/cmd/deployer/internal/httprpc/apiv1"
	"goji.io"
)

// Config configures the HTTP server
type Config struct {
	service_common.BaseHTTPServerConfig
}

// Load HTTP server config
func (c *Config) Load(dconf *distconf.Distconf) error {
	return c.BaseHTTPServerConfig.Verify(dconf, "deployer")
}

// Server for HTTP commands
type Server struct {
	service_common.BaseHTTPServer
	APIv1 apiv1.API
}

// DeployerRoutes sets up routes for the deployer server
func (s *Server) DeployerRoutes(mux *goji.Mux) {
	s.APIv1.Routes(&s.BaseHTTPServer, mux)
}
