package main

import (
	"fmt"
	"io"
	"log"
	"net/http"
	_ "net/http/pprof"
	"os"
	"runtime"
	"runtime/debug"
	"strconv"
	"sync/atomic"
	"time"
)

func main() {
	go func() {
		log.Println(http.ListenAndServe(":6060", nil))
	}()

	s := http.Server{}
	mux := http.NewServeMux()
	totalCount := int64(0)
	mux.Handle("/cpu", http.HandlerFunc(func(rw http.ResponseWriter, req *http.Request) {
		duration, err := time.ParseDuration(req.URL.Query().Get("duration"))
		if err != nil {
			duration = time.Minute
		}
		throttle, err := strconv.ParseInt(req.URL.Query().Get("throttle"), 10, 64)
		if err != nil {
			throttle = 1024
		}
		now := time.Now()
		go func() {
			i := int64(0)
			for now.Add(duration).After(time.Now()) {
				i++
				if i == throttle {
					time.Sleep(time.Nanosecond)
					i = 0
				}
			}
			atomic.AddInt64(&totalCount, i)
			fmt.Printf("Finished background CPU thread\n")
		}()
		_, _ = io.WriteString(rw, "ok!")
	}))

	mux.Handle("/end", http.HandlerFunc(func(rw http.ResponseWriter, req *http.Request) {
		fmt.Println("Ending the service")
		os.Exit(0)
	}))

	mux.Handle("/mem", http.HandlerFunc(func(rw http.ResponseWriter, req *http.Request) {
		duration, err := time.ParseDuration(req.URL.Query().Get("duration"))
		if err != nil {
			duration = time.Minute
		}
		memory, err := strconv.ParseInt(req.URL.Query().Get("memory"), 10, 64)
		if err != nil {
			memory = 1024 * 1024 * 100 // 100 meg
		}
		x := make([]byte, memory)
		for i := range x {
			x[i] = 3
		}
		go func() {
			<-time.After(duration)
			x[0] = 2
			x = nil
			fmt.Printf("Running gc to clear up %d memory\n", memory)
			runtime.GC()
			debug.FreeOSMemory()
			fmt.Printf("GC finished\n")
		}()
		_, _ = io.WriteString(rw, "ok!")
	}))
	s.Addr = ":8080"
	s.Handler = mux
	fmt.Println("Listening")
	fmt.Println(s.ListenAndServe())
}
