#!/bin/bash
set -ex

. "../jenkins/common.sh"
debug_info

function each_team_docker() {
(
  cd $(dirname $1)

  BINARY_NAME=$(basename $(dirname $1))
  TEAM_NAME=$(basename $(dirname $(dirname $(dirname $1))))
  if [ -z "$TEAM_NAME" ] || [ $TEAM_NAME == "." ]; then
    echo "Skipping empty team for dockerfile $1"
    return 0
  fi
  build_tag_push $TEAM_NAME $BINARY_NAME $GIT_COMMIT
)
}

find . -type f -name Dockerfile -not -path './vendor/*' | while read line ; do
  each_team_docker $line
done
