# service-common

Common functionality of all feed services

# ENVIRONMENT

Assuems an env variable named "ENVIRONMENT" that is the environment of the service.  Examples include staging, development, production, etc

# Config

Config is loaded from
* Command line (with prefix --conf:)
* Environment variables (with the prefix SERVICE_) (Replace SERVICE with your service name.  For example, fanout_stdout.enabled=false)
* JSON file at config/<ENVIRONMENT>.json.  For example, a file at config/development.json
* Consul addresses
* * settings/feeds/ENVIRONMENT/SERVICE
* * settings/feeds/ENVIRONMENT
* An example consul address is http://consul.internal.justin.tv/ui/dist/#/us-west2/kv/settings/feeds/staging/

# Sandstorm (secrets)

Sandstorm expects a config value sandstorm.arn which is the sandstorm ARN.  For example, arn:aws:iam::734326455073:role/sandstorm/production/templated/role/feeds-staging

It then loads sandstorm secrets inside /TEAM/SERVICE/ENVIRONMENT/KEY.  For example, rollbar.access_token is loaded from feeds/fanout/staging/rollbar.access_token

# Logging

Logging to stdout and rollbar is enabled.  Use the flag logging.to_stdout to enable/disable stdout logging.  Rollbar logging is error stack smart, allowing rollbar to log the location of when errors are created, not just where they are logged.

# Statsd

Assumes config value statsd.hostport.  Prefixes all statsd with TEAM.SERVICE.ENVIRONMENT.HOSTNAME

# Basic go stats to statsd

Collects basic stats at an interval.

# Expvar

Exports common information, and config/secrets/code version/etc.  Set your own expvar inside ExpvarHandler.Exported

# Debug port

Debug port for pprof and other debug information.
