package service_common

import (
	"bytes"
	"io"
	"testing"
	"time"

	. "github.com/smartystreets/goconvey/convey"
	"golang.org/x/net/context"
)

func TestLineOutputWatcher(t *testing.T) {
	Convey("With line checker", t, func() {
		dst := &bytes.Buffer{}
		w := &LineOutputWatcher{
			Out: dst,
		}
		Convey("Should find substrings", func() {
			c := w.FindFirstSubstr("ello w")
			io.WriteString(w, "Not found\n")
			io.WriteString(w, "Not found again\n")
			io.WriteString(w, "hello ")
			io.WriteString(w, "world\n")
			ctx, cancel := context.WithTimeout(context.Background(), time.Millisecond*100)
			defer cancel()
			wasFound := c.Block(ctx)
			So(wasFound, ShouldEqual, true)
			wasFound = c.Block(ctx)
			So(wasFound, ShouldEqual, true)
		})

		Convey("Should not find substrings", func() {
			c := w.FindFirstSubstr("ello w!!")
			io.WriteString(w, "Not found\n")
			io.WriteString(w, "Not found again\n")
			io.WriteString(w, "hello world\n")
			ctx, cancel := context.WithTimeout(context.Background(), time.Millisecond*100)
			defer cancel()
			wasFound := c.Block(ctx)
			So(wasFound, ShouldEqual, false)
			wasFound = c.Block(ctx)
			So(wasFound, ShouldEqual, false)
		})
	})
}
