package xray

import (
	"context"
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestTraceID(t *testing.T) {
	t.Parallel()
	x := XRay{}
	ctx, seg := x.newSegment(context.Background(), "name")
	traceID := TraceID(ctx)
	assert.Equal(t, seg.TraceID, traceID)
}

func TestEmptyTraceID(t *testing.T) {
	t.Parallel()
	traceID := TraceID(context.Background())
	assert.Empty(t, traceID)
}
