package heartbeat

//Secret a heartbeat of a secret
type Secret struct {
	Name           string `json:"name,required"`
	UpdatedAt      int64  `json:"updated_at,required"`
	Tombstone      bool   `json:"tombstone"`
	FetchedAt      int64  `json:"fetched_at"`
	DoNotBroadcast bool   `json:"do_not_broadcast"`
	KeyARN         string `json:"key_arn"`
}

//heartbeatState to be reported to inventory
type heartbeatState struct {
	host            string
	service         string
	secretsToReport map[string]*Secret
}

//DynamoHeartbeat stores the secrets heartBeat to be reported to inventory
type DynamoHeartbeat struct {
	CompositeKey      string `dynamodbav:"composite_key"`
	Service           string `dynamodbav:"service"`
	UpdatedAt         int64  `dynamodbav:"updated_at"`
	Tombstone         bool   `dynamodbav:"tombstone"`
	FirstRetrievedAt  int64  `dynamodbav:"first_retrieved_at"`
	HeartbeatReceived int64  `dynamodbav:"heartbeat_received"`
	FetchedAt         int64  `dynamodbav:"fetched_at"`
	ExpiresAt         int64  `dynamodbav:"expires_at"`
	Secret            string `dynamodbav:"secret"`
	Host              string `dynamodbav:"host"`
	DoNotBroadcast    bool   `dynamodbav:"do_not_broadcast"`
	KeyARN            string `dynamodbav:"key_arn"`
}

// heartbeat represents the heartbeat that a sandstorm manager will send to
// inventory manager service.
type heartbeat struct {
	// Secrets is an array that represents the secrets that a host is retrieving
	Secrets []*Secret `json:"secrets"`

	// Hostname is the name of the host that sent the heartbeat.
	Host string `json:"host,required"`

	//Name of the service who pulled the secrets.
	Service string `json:"service,required"`
}
