package heartbeat

import (
	"bytes"
	"io/ioutil"
	"net/http"
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestWrapRequestBodyWithSeeker(t *testing.T) {
	t.Run("entire body should be read", func(t *testing.T) {
		const bodyContent = "myBody"

		assert := assert.New(t)

		req := &http.Request{
			Body: ioutil.NopCloser(bytes.NewBuffer([]byte(bodyContent))),
		}

		seekableBody, err := wrapRequestBodyWithSeeker(req)
		assert.NoError(err)

		reqBody, err := ioutil.ReadAll(seekableBody)
		assert.NoError(err)
		assert.Equal(bodyContent, string(reqBody))
	})

	t.Run("should return nil on nil body", func(t *testing.T) {
		assert := assert.New(t)

		req := &http.Request{}

		seekableBody, err := wrapRequestBodyWithSeeker(req)
		assert.NoError(err)
		assert.Nil(seekableBody)
	})
}
