job {
    name 'systems-sandstorm-build'
    using 'TEMPLATE-autobuild'

    /**
     * credentials required for running tests with manta
     */
    wrappers {
      credentialsBinding {
        string 'AWS_SECRET_ACCESS_KEY', 'sse_sandstorm_aws_secret_access'
        string 'AWS_ACCESS_KEY_ID', 'sse_sandstorm_aws_access_id'
        string 'dta_tools_deploy', 'dta_tools_deploy'
        file('COURIERD_PRIVATE_KEY', 'courierd')
        file('AWS_CONFIG_FILE', 'aws_config')
      }
      environmentVariables {
        env('ENVIRONMENT', 'development')
      }
    }


    scm {
        git {
            remote {
                github 'systems/sandstorm', 'ssh', 'git-aws.internal.justin.tv'
                credentials 'git-aws-read-key'
            }
        }
    }
    steps {
        shell 'rm -rf .manta/'
        shell 'manta -update -v -e AWS_ACCESS_KEY_ID -e AWS_SECRET_ACCESS_KEY -f .manta.json'
        shell 'manta -v -e AWS_ACCESS_KEY_ID -e AWS_SECRET_ACCESS_KEY -f cmd/sandstorm-apiserver/.manta.json'
        shell 'manta -v -e AWS_ACCESS_KEY_ID -e AWS_SECRET_ACCESS_KEY -f cmd/sandstorm-cli/sandstorm-cmd-manta-deb.json'
        shell 'manta -v -e AWS_ACCESS_KEY_ID -e AWS_SECRET_ACCESS_KEY -f .manta.python.json'
        shell './cmd/sandstorm-agent/build_agent.sh'
        shell 'cp -rf cmd/scripts .manta/dest/'
        shell 'cp .manta/dest/test_report.xml test_report.xml'
        // this is from https://git-aws.internal.justin.tv/release/jenkins-jobs/blob/master/1templates/base.groovy
        saveDeployArtifact 'systems/sandstorm', '.manta/dest'
    }
    publishers {
        postBuildScripts {
            steps {
                reportCodeCoverage('systems/sandstorm', '.manta/dest', '*.out')
            }
            onlyIfBuildSucceeds(false)
        }

        archiveArtifacts {
            pattern('.manta/*.log')
            pattern('test_report.xml')
            pattern('.manta/dest/coverage.out')
            pattern('.manta/dest/coverage.html')
            pattern('codecov_coverage.json')
            allowEmpty()
        }
        archiveJunit('test_report.xml') {
            allowEmptyResults()
        }
    }
}

job {
    name "systems-sandstorm-deploy"
    using 'TEMPLATE-deploy-aws'
    steps {
        shell 'courier deploy --repo systems/sandstorm --dir /opt/twitch/sandstorm'
    }
}

job {
    name "systems-sandstorm-cmd-aptly"
    parameters {
        stringParam 'GIT_COMMIT'
    }

    steps {
      downloadDeployArtifact 'systems/sandstorm'
      uploadDeb 'precise/sandstorm.deb', 'precise'
      uploadDeb 'xenial/sandstorm.deb', 'xenial'
      uploadWin('windows/sandstorm.exe', 'v0.1.0')
      shell 'sh scripts/cli_s3_upload.sh'
    }
    wrappers {
      sshAgent 'git-aws-read-key'
      preBuildCleanup()
      timestamps()
      credentialsBinding {
        string 'AWS_SECRET_ACCESS_KEY', 'twitch-sandstorm-aws-jenkins-sandstormCLI-upload-key'
        string 'AWS_ACCESS_KEY_ID', 'twitch-sandstorm-aws-jenkins-sandstormCLI-upload-id'
        file('AWS_CONFIG_FILE', 'aws_config')
        string 'dta_tools_deploy', 'dta_tools_deploy'
      }
    }
}

// Sandstorm-Agent related jobs
job {
    name 'systems-sandstorm-agent-aptly'
    parameters {
      stringParam 'GIT_COMMIT'
    }
    steps {
      downloadDeployArtifact 'systems/sandstorm'
      uploadDeb 'sandstorm-agent.deb', 'precise'
      uploadDeb 'sandstorm-agent.deb', 'trusty'
      uploadDeb 'sandstorm-agent.deb', 'xenial'
      uploadRPM('sandstorm-agent.rpm')
    }
    wrappers {
      preBuildCleanup()
      timestamps()
      credentialsBinding {
        file('AWS_CONFIG_FILE', 'aws_config')
        string 'dta_tools_deploy', 'dta_tools_deploy'
      }
    }
}

job {
    name 'systems-sandstorm-agent-aptly-canary'
    parameters {
      stringParam 'GIT_COMMIT'
    }
    steps {
      downloadDeployArtifact 'systems/sandstorm'
      uploadDeb 'sandstorm-agent-canary.deb', 'precise'
      uploadDeb 'sandstorm-agent-canary.deb', 'trusty'
      uploadDeb 'sandstorm-agent-canary.deb', 'xenial'
      uploadRPM('sandstorm-agent-canary.rpm')
    }
    wrappers {
      preBuildCleanup()
      timestamps()
      credentialsBinding {
        file('AWS_CONFIG_FILE', 'aws_config')
        string 'dta_tools_deploy', 'dta_tools_deploy'
      }
    }
}
