package manager

import (
	"testing"

	"code.justin.tv/common/ddbmetrics"
	invMocks "code.justin.tv/systems/sandstorm/inventory/heartbeat/mocks"
	"code.justin.tv/systems/sandstorm/mocks"
	"github.com/aws/aws-sdk-go/service/dynamodb"
	"github.com/cactus/go-statsd-client/statsd"
	"github.com/stretchr/testify/assert"
)

const testSecretName = "testSecretName"

type managerTest struct {
	m             *Manager
	mockDynamoDB  *mocks.DynamoDBAPI
	mockEnveloper *mocks.Enveloper
	mockInventory *invMocks.API
}

func (mt *managerTest) teardown(t *testing.T) {
	assert.True(t, mt.mockDynamoDB.AssertExpectations(t))
	assert.True(t, mt.mockEnveloper.AssertExpectations(t))
	assert.True(t, mt.mockInventory.AssertExpectations(t))
}

func newManagerTest(t *testing.T) *managerTest {
	noopStatter, err := statsd.NewNoopClient()
	if err != nil {
		t.Fatal(err)
	}

	ddb := new(mocks.DynamoDBAPI)
	ddbMetrics := ddbmetrics.New(new(dynamodb.DynamoDB), noopStatter)
	ddbMetrics.Start()
	mockedInventory := new(invMocks.API)

	env := new(mocks.Enveloper)

	m := &Manager{
		Envelope:        env,
		DynamoDB:        ddb,
		metrics:         ddbMetrics,
		inventoryClient: mockedInventory,
	}
	return &managerTest{
		m:             m,
		mockDynamoDB:  ddb,
		mockEnveloper: env,
		mockInventory: mockedInventory,
	}
}

func createMocks(t *testing.T) (*Manager, *mocks.DynamoDBAPI, *mocks.Enveloper) {
	mt := newManagerTest(t)
	return mt.m, mt.mockDynamoDB, mt.mockEnveloper
}
