sandstorm {
    tablename = "sandstorm-testing"
    key_id = "alias/sandstorm-testing"
    ddb_statsd_host_port = "127.0.0.1:8125"
    ddb_statsd_prefix = "sandstorm-api"
    role_arn = "arn:aws:iam::734326455073:role/sandstorm-apiserver-testing"
    region = "us-west-2"

    inventory_admin_role_arn = "arn:aws:iam::516651178292:role/inventory-admin-testing"
    inventory_role_arn = "arn:aws:iam::516651178292:role/inventory-gateway-execute-api-invoke-testing"
    inventory_status_url = "https://o1ll5pv4hh.execute-api.us-west-2.amazonaws.com/testing",
    service_name = "sandstorm-manager-apiserver-testing"
}

oauth {
      client_id = "foo"
      secret = "bar"
      admin_groups = [
      "team-syseng"
      ]
      checktoken_url = "https://guardian.dev.us-west2.twitch.tv/oauth2/check_token"
}

http {
     listen = "127.0.0.1:4711"
}

cors {
    allowed_origins = [
        "http://localhost*",
        "https://dashboard-staging.internal.justin.tv",
        "https://dashboard.internal.justin.tv"
    ]
    allowed_methods = ["GET", "POST", "PUT", "PATCH", "DELETE"]
    allowed_headers = ["*"]
    debug = false
}

syslog {
    enabled = false
    host = "127.0.0.1"
    facility = "local4"
    tag = "sandstorm-server"
    # minimum log level: debug, info, warn, error, fatal
    level = "debug"
    # output format: json, logstash, text
    format = "text"
    file = "sandstorm.log"
}

changelog {
    enabled = false
    # Changelog endpoint - defaults to "https://changelog.internal.justin.tv/api/events"
    endpoint = "https://changelog-test.internal.justin.tv/api/events"
    # Changelog category - defaults to sandstorm-api-server
    category = "sandstorm-api-test"
}

policy_generator {
    rw_aux_policy_arn = "arn:aws:iam::734326455073:policy/sandstorm/testing/aux_policy/sandstorm-agent-testing-rw-aux"
    aux_policy_arn = "arn:aws:iam::734326455073:policy/sandstorm/testing/aux_policy/sandstorm-agent-testing-aux"
    environment = "testing"
}
