variable "name" {}
variable "environment" {}
variable "team" {}
variable "dns_name" {}
variable "zone_id" {}

# AWS DNS Account
variable "dns_account" {
  default = "twitch-aws"
}

# DNS Zone ID
variable "dns_zone_id" {
  default = "ZRG00SM48517Z"
}

provider "aws" {
  alias   = "dns"
  region  = "us-west-2"
  profile = "${var.dns_account}"
}

resource "aws_route53_record" "internal_alias_record" {
  provider = "aws.dns"
  zone_id  = "${var.dns_zone_id}"
  name     = "${var.team}-${var.name}.${var.environment}.us-west2.justin.tv"
  type     = "A"

  alias {
    name                   = "${var.dns_name}"
    zone_id                = "${var.zone_id}"
    evaluate_target_health = true
  }
}
