variable name {}
variable team {}
variable environment {}
variable statsite_task_family {}
variable xray_task_family {}

resource "aws_ecs_cluster" "cluster" {
  name = "${var.name}"
}

module "statsite_daemon" {
  source      = "../perhostdaemon"
  environment = "${var.environment}"
  name        = "statsite"
  task_family = "${var.statsite_task_family}"
  cluster     = "${aws_ecs_cluster.cluster.name}"
}

module "xray_daemon" {
  source      = "../perhostdaemon"
  environment = "${var.environment}"
  name        = "xray"
  task_family = "${var.xray_task_family}"
  cluster     = "${aws_ecs_cluster.cluster.name}"
}

output cluster_name {
  value = "${aws_ecs_cluster.cluster.name}"
}

output cluster_id {
  value = "${aws_ecs_cluster.cluster.id}"
}
