resource "aws_ecs_service" "app" {
  name = "${var.name}-${var.environment}"

  lifecycle {
    ignore_changes = ["task_definition"]
  }

  task_definition = "${var.task_family}"

  // Whatever the maximum desired count is
  // http://docs.aws.amazon.com/AmazonECS/latest/developerguide/service_limits.html
  desired_count = "1000"

  cluster = "${var.cluster}"

  deployment_maximum_percent         = 200
  deployment_minimum_healthy_percent = 50

  placement_constraints {
    type = "distinctInstance"
  }
}
