terraform {
  backend "s3" {
    bucket  = "twitch-feed-aws"
    key     = "tfstate/feeds/helloworld/terraform/canary"
    region  = "us-west-2"
    profile = "twitch-feed-aws"
  }
}

data "terraform_remote_state" "helloworld_production" {
  backend = "s3"

  config {
    bucket  = "${var.account}"
    key     = "tfstate/${var.team}/${var.name}/terraform/production"
    region  = "${var.region}"
    profile = "${var.account}"
  }
}

module "helloworld" {
  source           = "../../../modules/helloworld"
  team             = "${var.team}"
  environment      = "${var.environment}"
  target_group_arn = "${data.terraform_remote_state.helloworld_production.target_group_arn}"
  region           = "${var.region}"
  cluster_name     = "${data.terraform_remote_state.core.common_cluster_name}"
  account          = "${var.account}"

  min_size       = "1"
  desired_count  = "1"
  max_size       = "2"
  container_port = "${var.container_port}"
}

output task_cpu {
  value = "1024"
}

output task_mem {
  value = "512"
}
