terraform {
  backend "s3" {
    bucket  = "twitch-feed-aws"
    key     = "tfstate/feeds/core/terraform/production"
    region  = "us-west-2"
    profile = "twitch-feed-aws"
  }
}

module "core" {
  source = "../../../../common/core"

  team   = "${var.team}"
  region = "${var.region}"

  environment             = "${var.environment}"
  container_log_retention = "30"
  xray_role               = "arn:aws:iam::641044725657:role/foundation-xray-role"
}

variable owner {
  default = "jlindamo@twitch.tv"
}

variable instance_type {
  default = "c4.4xlarge"
}

module "ecsasg" {
  source                        = "../../../../common/ecsasg"
  cluster_name                  = "${module.core.common_cluster_name}"
  account                       = "${var.account}"
  environment                   = "${var.environment}"
  min_size                      = "2"
  desired_capacity              = "3"
  max_size                      = "5"
  team                          = "${var.team}"
  owner                         = "${var.owner}"
  name                          = "common"
  instance_type                 = "${var.instance_type}"
  container_instance_profile_id = "${module.core.container_instance_profile_id}"
}

output container_loggroup {
  value = "${module.core.container_loggroup}"
}

output container_instance_profile_id {
  value = "${module.core.container_instance_profile_id}"
}

output container_iam_role {
  value = "${module.core.container_iam_role}"
}

output service_iam_role {
  value = "${module.core.service_iam_role}"
}

output task_autoscale_iam_role {
  value = "${module.core.task_autoscale_iam_role}"
}

output "statsite_task_family" {
  value = "${module.core.statsite_task_family}"
}

output "xray_task_family" {
  value = "${module.core.xray_task_family}"
}

output "xray_task_role" {
  value = "${module.core.xray_task_role}"
}

output common_cluster_name {
  value = "${module.core.common_cluster_name}"
}

output common_cluster_id {
  value = "${module.core.common_cluster_id}"
}

output build_role {
  value = "${module.core.build_role}"
}
