terraform {
  backend "s3" {
    bucket  = "twitch-feed-aws"
    key     = "tfstate/feeds/helloworld/terraform/production"
    region  = "us-west-2"
    profile = "twitch-feed-aws"
  }
}

module "alb" {
  source      = "../../../../common/alb"
  name        = "${var.name}"
  owner       = "${var.owner}"
  environment = "${var.environment}"
  account     = "${var.account}"
  team        = "${var.team}"
}

module "helloworld" {
  source           = "../../../modules/helloworld"
  team             = "${var.team}"
  environment      = "${var.environment}"
  target_group_arn = "${module.alb.target_group_arn}"
  region           = "${var.region}"
  cluster_name     = "${data.terraform_remote_state.core.common_cluster_name}"
  account          = "${var.account}"

  min_size       = "1"
  desired_count  = "2"
  max_size       = "3"
  container_port = "${var.container_port}"
}

output task_cpu {
  value = "1024"
}

output task_mem {
  value = "512"
}

output target_group_arn {
  value = "${module.alb.target_group_arn}"
}
