### ----- task level iam policies -----
resource "aws_iam_role" "helloworld_task" {
  name               = "${var.name}-${var.environment}"
  assume_role_policy = "${data.aws_iam_policy_document.helloworld_task.json}"
}

data "aws_iam_policy_document" "helloworld_task" {
  statement {
    actions = ["sts:AssumeRole"]

    principals {
      type        = "Service"
      identifiers = ["ecs-tasks.amazonaws.com"]
    }
  }
}

resource "aws_iam_role_policy" "policy" {
  name = "${var.name}_${var.environment}_dynamo_policy"
  role = "${aws_iam_role.helloworld_task.id}"

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Action": [
        "dynamodb:*"
      ],
      "Resource": [
        "arn:aws:dynamodb:us-west-2:724951484461:table/test_from_hello"
      ]
    }
  ]
}
EOF
}
