module "simpleservice" {
  source           = "../../../common/simpleservice"
  account          = "${var.account}"
  name             = "${var.name}"
  cluster_name     = "${var.cluster_name}"
  region           = "${var.region}"
  team             = "${var.team}"
  environment      = "${var.environment}"
  desired_count    = "${var.desired_count}"
  target_group_arn = "${var.target_group_arn}"
  task_role_arn    = "${aws_iam_role.helloworld_task.arn}"
  container_port   = "${var.container_port}"
}

module "taskcpuscale" {
  source       = "../../../common/taskcpuscale"
  max_size     = "${var.max_size}"
  min_size     = "${var.min_size}"
  account      = "${var.account}"
  region       = "${var.region}"
  cluster_name = "${var.cluster_name}"
  service      = "${module.simpleservice.service_name}"
  team         = "${var.team}"
  environment  = "${var.environment}"
}

output task_role_arn {
  value = "${aws_iam_role.helloworld_task.arn}"
}

output task_family {
  value = "${module.simpleservice.task_family}"
}

output cluster_name {
  value = "${module.simpleservice.cluster_name}"
}

output service_name {
  value = "${module.simpleservice.service_name}"
}
