# Isengard Credentials

`isengard_credentials` is a script to get AWS credentials from Isengard using Midway authentication on any network. You can use this script to get temporary AWS credentials for the AWS CLI and SDKs using [credential_process](https://docs.aws.amazon.com/cli/latest/topic/config-vars.html#sourcing-credentials-from-external-processes). This moves away from hard-coding permanent IAM keys in `~/.aws/credentials`

`credential_process` was added to aws-sdk-go in [v1.16.0](https://github.com/aws/aws-sdk-go/blob/master/CHANGELOG.md#release-v1160-2018-12-05)

## Language Support (Updated 6-5-2019)

| Supported | Language | Additional Tool(s) |
| --- | --- | --- |
| Yes | [Go](https://github.com/aws/aws-sdk-go/pull/2217) (>=v1.16.0 2018-12-05) | terraform (>=0.11.14) and terraform-aws-provider (>=v1.52.0). [Examples](https://git-aws.internal.justin.tv/timotyen/terraform_profile_example) |
| Yes | [Python](https://github.com/boto/botocore/pull/1316) (>=1.8.0 2017-11-21) | aws-cli (>=1.12.0 2017-11-21) |
| Yes | [JavaScript](https://github.com/aws/aws-sdk-js/pull/2559) (>=v2.429.0 2019-03-26) | aws-cdk (Pending [aws-cdk#3008](https://github.com/aws/aws-cdk/issues/3008)) |
| Yes | [Ruby](https://github.com/aws/aws-sdk-ruby/pull/1820) (>=3.22.1 2018-06-28) | |
| Yes | [Java](https://github.com/aws/aws-sdk-java-v2/pull/1166) (>= 2.5.26 2019-04-16) | |

## Setup

Clone this repo
```bash
git clone git@git.xarth.tv:twitch/isengard_credentials.git

# OR if you use golang:
go get code.justin.tv/twitch/isengard_credentials
```

Add to your PATH


*macOS 10.15 or later (which uses zsh by default). [Source](https://stackoverflow.com/a/18077919) of this syntax.*

Within `.zshrc`
```zsh
path+=('/path/to/isengard_credentials')
export PATH
```

*macOS 10.14 or earlier (which uses bash by default)*
```bash
export PATH="/path/to/isengard_credentials:$PATH"

# OR if you cloned this repo with "go get" command, you can add the below to your bash_profile or zshrc file:
export PATH="$GOPATH/src/code.justin.tv/twitch/isengard_credentials:$PATH"
```

Install Mac mwinit (curl command requires being on the WPA2 network). This version of mwinit supports AEA.
```bash
curl --fail -O https://s3.amazonaws.com/com.amazon.aws.midway.software/mac/mwinit \
&& chmod u+x mwinit && sudo mv mwinit /usr/local/bin/mwinit
which mwinit
mwinit --version
```

Install jq
```bash
brew install jq
```

Update your `~/.aws/credentials` file. The role should be an Isengard console access role you have access to; the right most column on https://isengard.amazon.com/console-access.
```bash
# Example entry
[twitch-account-name]
region = us-west-2
credential_process = isengard_credentials --account-id <account_id> --role <role>
```

If you would like to configure `~/.aws/config` instead, it will work with the AWS CLI by default. However, it will not work with aws-sdk-go unless [AWS_SDK_LOAD_CONFIG=1](https://github.com/aws/aws-sdk-go/blob/53229ac1c777fca17476612c7e81ea168bc89a40/aws/credentials/processcreds/provider.go#L16<Paste>) is set.

Test AWS CLI
```bash
mwinit --aea
AWS_REGION=us-west-2 AWS_PROFILE=twitch-account-name aws s3 ls
```
