#!/bin/bash

function root__bastion() {
  if [[ "${1-}" == "help" ]]; then
    echo "Create tunnels or run connections on the bastion host"
    exit 0
  fi
  process_build bastion__ $@
}

function bastion__host_ip() {
  if [[ "${1-}" == "help" ]]; then
    echo "Print the bastion host's IP"
    exit 0
  fi
  if [[ ! -z "${BASTION_HOST_IP-}" ]]; then
    echo ${BASTION_HOST_IP}
    return
  fi
  if [[ "${USE_BUILDER}" == "true" ]]; then
    make_exec builder run bastion host_ip $@
  fi
  AWS_PROFILE="staging-infra" cached_cloudformation_output LdapBastionSSHIP
}

function bastion__tunnel() {
  # TODO: Allow detection of if the tunnel exists
  if [[ "${1-}" == "help" ]]; then
    echo "Setup a bastion SSH tunnel for local development"
    exit 0
  fi
  if ! host_ip=$(DEBUG=false make_run bastion host_ip | sed -e 's/^[[:space:]]*//' -e 's/[[:space:]]*$//'); then
    echo "Unable to find bastion host IP"
    echo "You may need to run 'mwinit' or 'teleport-bastion login'"
    exit 1
  fi
  set -x
  TC="$BASTION_ENV" ssh -o ConnectTimeout=10 -o "ExitOnForwardFailure yes" -D 4456 -N "${host_ip}"
}

# Execute a command on the bastion host
function bastion__execute() {
  if [[ "${1-}" == "help" ]]; then
    echo "Execute a shell command on the bastion"
    exit 0
  fi

  if ! host_ip=$(DEBUG=false make_run bastion host_ip | sed -e 's/^[[:space:]]*//' -e 's/[[:space:]]*$//'); then
    echo "Unable to find host IP"
    echo "You may need to run 'mwinit' or 'teleport-bastion login'"
    exit 1
  fi

  if [[ -z "$host_ip" ]]; then
    echo "Unable to find bastion host IP"
    make_run bastion host_ip
    return 1
  fi
  TC="$BASTION_ENV" ssh -o ConnectTimeout=10 "${host_ip}" -- $@
}
